#include <iostream>
#include <vector>

using namespace std;

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    int n;
    cin >> n;
    vector<pair<long long, long long>> masts(n);
    vector<long long> result(n, -1);

    for (int i = 0; i < n; i++) {
        cin >> masts[i].first;
    }

    for (int i = 0; i < n; i++) {
        cin >> masts[i].second;
    }

    vector<int> stack;
    stack.reserve(n);
    for (int i = 0; i < n; i++) {
        while (!stack.empty() && masts[stack.back()].second < masts[i].second) {
            stack.pop_back();
        }

        if (!stack.empty()) {
            int j = stack.back();
            result[i] = masts[i].first - masts[j].first - masts[j].second + masts[i].second;
        }

        stack.push_back(i);
    }

    stack.clear();
    for (int i = n - 1; i >= 0; i--) {
        while (!stack.empty() && masts[stack.back()].second < masts[i].second) {
            stack.pop_back();
        }

        if (!stack.empty()) {
            int j = stack.back();
            long long dist = masts[j].first - masts[j].second + masts[i].second - masts[i].first;
            if (result[i] == -1 || dist < result[i]) result[i] = dist;
        }

        stack.push_back(i);
    }

    for (auto res : result) {
        cout << res << endl;
    }

    return 0;
}